 ; PW - reset the width of a polyline, line, arc or circle.
 ; Copyright 1994, 2000, 2004, 2010 by Rocket Software Ltd.
 ; Why is there no corner entity?
 (DEFUN C:PW (/ pl ss pwidp num enam entt typ dia cen p1 p2 p3 p4)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq pl (getvar "plinewid"))
  (prompt "Select stuff to rewidth or <Return> for all polylines: ")
  (setq ss (ssget '((-4 . "<or") (0 . "line") (0 . "circle") (0 . "arc")
                        (0 . "lwpolyline") (0 . "polyline") (-4 . "or>"))))
  (if (null ss) (setq ss (ssget "x" '((-4 . "<or") (0 . "lwpolyline")
                                      (0 . "polyline") (-4 . "or>")))))
  (if ss
      (progn
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
           (if (or (null wasp) (null misps))
               (if (null (load "misps" ()))
                   (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
           (if (/= (type pwid) 'REAL) (setq pwid (misps)))
           (setq pwidp (getdist (strcat "New pline width <"
                                         (rtos pwid 2 2) ">: ")))
           (if pwidp (setq pwid pwidp))
           (setq num 0)
           (while (and ss (setq enam (ssname ss num)))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (setq typ (cdr (assoc 0 entt)))
                  (cond ((or (= typ "LINE") (= typ "ARC"))
                         (command "pedit" enam "y" "w" pwid ""))
                        ((or (= typ "POLYLINE") (= typ "LWPOLYLINE"))
                         (command "pedit" enam "w" pwid ""))
                        ((= typ "CIRCLE")
                         (setq dia (cdr (assoc 40 entt)))
                         (setq cen (cdr (assoc 10 entt)))
                         (setq p1 (polar cen 0 dia))
                         (setq p2 (polar cen (/ pi 2) dia))
                         (setq p3 (polar cen pi dia))
                         (setq p4 (polar cen (* pi 1.5) dia))
                         (entdel enam)
                         (command "pline" p1 "w" pwid "" p2 p3 p4 "c")
                         (command "pedit" "l" "f" ""))))))
  (setvar "plinewid" pl)
  (command "undo" "end")
 (princ))